# 🩺 Guía de Configuración y Despliegue - Robot Médico

Este documento detalla los pasos necesarios para garantizar que el sistema funcione al 100% en entornos de producción, tanto en Windows como en Linux.

---

## 🖥️ Configuración en Windows

### 1. Grabadora de CD/DVD
El sistema utiliza la API **IMAPI2**. Asegúrese de que el servicio "Servicio de grabación de CD de IMAPI" no esté deshabilitado (aunque Windows 10/11 lo maneja automáticamente).

### 2. Permisos de PowerShell
Para que el robot pueda ejecutar los scripts de grabación y expulsión, abra PowerShell como Administrador y ejecute:
```powershell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope LocalMachine
```

### 3. Ejecución del Robot
Se recomienda ejecutar el robot en una consola dedicada:
```cmd
php backend/robot.php
```

---

## 🐧 Configuración en Linux (Ubuntu/Debian)

### 1. Instalación de Dependencias
Es necesario instalar las herramientas de grabación:
```bash
sudo apt-get update
sudo apt-get install wodim genisoimage growisofs blkid sg3-utils hdparm
```

### 2. Permisos del Helper (`cdrom_helper.sh`)
El archivo `backend/cdrom_helper.sh` debe tener permisos de ejecución y pertenecer a `root`:
```bash
sudo chown root:root backend/cdrom_helper.sh
sudo chmod +x backend/cdrom_helper.sh
```

### 3. Configuración de Sudoers (CRITICO)
Para que el servidor web (www-data) pueda expulsar y grabar discos sin pedir contraseña, edite el archivo sudoers:
```bash
sudo visudo
```
Agregue la siguiente línea al final del archivo (reemplace `/ruta/al/proyecto` por la ruta real):
```text
www-data ALL=(ALL) NOPASSWD: /ruta/al/proyecto/backend/cdrom_helper.sh
```

---

## 🌐 Arquitectura Cliente-Servidor

### Optimización del Frontend
El frontend ha sido optimizado para cargas rápidas y bajo consumo de recursos:
- **Build ligero**: Se eliminaron dependencias pesadas (`framer-motion`, `lucide-react`, `axios`).
- **Build seguro**: Configurado para no congelar el equipo (`maxParallelFileOps: 2`).
- **Independencia**: El frontend detecta automáticamente la IP del servidor, permitiendo acceso desde cualquier equipo de la red.

### Comandos de Build
Si realiza cambios en el frontend, use:
```bash
npm run build
```
Esto generará la carpeta `dist` lista para ser servida por XAMPP o Apache.

---

## 🛠️ Solución de Problemas (Troubleshooting)

- **El disco no se expulsa**: En Windows, asegúrese de que ninguna otra aplicación esté bloqueando la unidad (como el Explorador de archivos con la unidad abierta).
- **Error "Licencia Vencida"**: Verifique la fecha del sistema y el campo `vencimiento` en `backend/db.json`.
- **CPU al 100% durante build**: El sistema ahora limita los hilos de Rollup, pero si persiste, use `npm run build` en lugar de `npm run build:full`.
