# Manual de Implementación - Sistema de Robot de Grabación Médica

Este manual detalla los pasos necesarios para instalar, configurar y operar el sistema de grabación automatizada PACS/DICOM tanto en entornos **Windows** como **Linux**.

---

## 📋 Requisitos Previos

### Comunes
- **PHP 7.4 o superior** (CLI y Módulo de Servidor Web).
- **Unidad de Grabación de CD/DVD** instalada y funcional.
- **Carpeta de Estudios**: Los estudios deben llegar a la subcarpeta `estudios_pendientes/` en formato de carpetas por paciente.

### Windows
- **XAMPP** (Recomendado) con Apache y PHP.
- **PowerShell 5.1+** (Viene por defecto en Windows 10/11).

### Linux
- **Distribución**: Ubuntu/Debian, CentOS/RHEL.
- **Herramientas**: `wodim`, `genisoimage`, `growisofs`, `eject`.
- **Acceso Root** para la configuración inicial.

---

## 🪟 Instalación en Windows (Vía XAMPP)

1.  **Copiar Archivos**: 
    - Copie la carpeta `SystemRobotWeb` dentro de `C:\xampp\htdocs\`.
2.  **Configurar Apache**:
    - Asegúrese de que el servidor Apache esté iniciado desde el Panel de Control de XAMPP.
3.  **Permisos**:
    - Normalmente XAMPP tiene permisos suficientes, pero asegúrese de que la carpeta del proyecto no sea de "Solo Lectura".
4.  **Acceso al Dashboard**:
    - Abra su navegador en: `http://localhost/SystemRobotWeb/index.html`

---

## 🐧 Instalación en Linux (Ubuntu/Debian/CentOS)

1.  **Mover Carpeta**: 
    - Coloque el proyecto en `/var/www/html/SystemRobotWeb`.
2.  **Ejecutar Instalador**:
    - El sistema incluye un script de configuración automática que instala dependencias y configura permisos de hardware y `sudoers`.
    ```bash
    cd /var/www/html/SystemRobotWeb/backend
    sudo bash install_linux.sh
    ```
3.  **Verificar Permisos**:
    - El script agregará al usuario del servidor web (`www-data` o `apache`) al grupo `cdrom`.
4.  **Acceso al Dashboard**:
    - `http://mip-servidor/SystemRobotWeb/index.html`

---

## 🤖 Ejecución del Robot (Backend)

El "Robot" es el proceso encargado de vigilar las carpetas y grabar físicamente los discos. Debe estar siempre ejecutándose en segundo plano.

**Comando para iniciar:**
```bash
cd SystemRobotWeb/backend
php robot.php
```

*Sugerencia: En Linux, puede usar `screen` o `nohup` para que el proceso no se cierre al salir de la terminal.*

---

## 🔐 Gestión de Licencia y Seguridad

El sistema requiere una activación para funcionar.

1.  **Acceso Inicial**: Al entrar al sistema, si la licencia no es válida, se mostrará un modal bloqueante.
2.  **Credenciales Maestras por Defecto**:
    - **Usuario**: `admin`
    - **Password**: `123456`
3.  **Proceso de Activación**:
    - Ingrese las credenciales actuales.
    - Especifique la cantidad de **Días** (ej: 365).
    - Presione **Activar**. El sistema generará una clave aleatoria y extenderá el vencimiento.
4.  **Cambio de Contraseña Seguro**:
    - Dentro del modal de activación, marque la casilla **"Cambiar credenciales de Administrador"**.
    - Ingrese los nuevos datos.
    - El cambio solo se aplicará si las credenciales **actuales** validadas son correctas.

---

## 🎨 Personalización de Marca (Branding)

Puede adaptar el sistema a la identidad visual de su institución:

1.  Entre al panel de **Configuración** (icono de engranaje ⚙️).
2.  Ubique la sección **Identidad del Sistema**.
3.  **Nombre**: Cambie "Robot Médico" por el nombre de su centro.
4.  **Logo**: Puede usar un Emoji (ej: 🏥, 💿) o un texto corto.
5.  **Efecto**: El cambio actualizará automáticamente el encabezado de la página, el título de la pestaña del navegador y el icono (favicon) de la pestaña.

---

## 🛠️ Resolución de Problemas

- **Error de Conexión**: Verifique que la ruta de la API sea accesible. El sistema usa rutas dinámicas, por lo que debería funcionar tanto por `localhost` como por IP privada.
- **Robot no graba**: Asegúrese de que hay un disco blanco insertado y que el proceso `php robot.php` tiene permisos para escribir en la unidad óptica.
- **Instalación de Node/Vite**: Si necesita reconstruir el frontend y el equipo se congela, use el comando optimizado `npm run build` que ya tiene límites de memoria configurados.

---
© 2026 Sistema Robot de Grabación Médica - Guía de Soporte Técnico.
