# 🏥 Sistema de Robot de Grabación Médica (Localhost)

Este sistema automatiza la detección, preparación y grabación de estudios médicos (DICOM, JPG, PNG) en CD/DVD, incluyendo un visor offline para su entrega al paciente.

## 🛠️ Tecnologías
- **Frontend**: React + Vite + Lucide Icons
- **Backend**: PHP 8 (API REST)
- **Base de Datos**: MySQL / MariaDB
- **Visor**: HTML5 / CSS3 / JavaScript (Autoejecutable)

## 📁 Estructura del Proyecto
- `/backend`: API REST y script del Robot.
- `/frontend`: Interfaz web de control.
- `/visor`: Código fuente del visor que se incluirá en cada disco.
- `/estudios_pendientes`: Carpeta monitoreada por el robot.
- `/docs`: Manuales y documentación técnica.

## 🚀 Instrucciones de Instalación

1. **Base de Datos**:
   - Importar el archivo `backend/schema.sql` en su servidor MySQL.
   - Configurar las credenciales en `backend/config.php`.

2. **Backend**:
   - Iniciar un servidor PHP apuntando a la carpeta raíz o usar XAMPP/Apache.
   - **En Linux**, asigne permisos de escritura a las carpetas de datos:
     ```bash
     chmod -R 777 estudios_pendientes estudios_procesados estudios_quemados backend/db.json
     ```
   - Ejecutar el robot en segundo plano:
     - **Windows**: `php backend/robot.php`
     - **Linux**: `bash backend/run_robot.sh` (requiere `dvd+rw-tools`)

3. **Frontend**:
   - Entrar en la carpeta `frontend`.
   - Instalar dependencias: `npm install`.
   - Iniciar entorno de desarrollo: `npm run dev`.

4. **Visor Offline**:
   - El visor ya está pre-configurado para ser copiado automáticamente por el robot a la estructura de cada disco.

## 🤖 Funcionamiento del Robot
1. El robot monitorea la carpeta `/estudios_pendientes`.
2. Al detectar una carpeta (formato: `NOMBRE-MODALIDAD-FECHA`), la registra en la DB.
3. El usuario puede "Iniciar Grabación" desde el panel web.
4. El robot prepara una estructura temporal, copia el visor y las imágenes.
5. Se espera la inserción de un disco y se inicia la grabación mediante comandos CLI del sistema (IMAPI en Windows o cdrecord en Linux).

## 📄 Licencia
Software desarrollado para entornos hospitalarios y centros radiológicos.
