#!/bin/bash
# fix_permissions.sh - Script de emergencia para otorgar permisos de root al CD-ROM
# Ejecutar con: sudo bash fix_permissions.sh

if [ "$EUID" -ne 0 ]; then
    echo "Debe ejecutarse como root (sudo bash $0)"
    exit 1
fi

WEB_USER="www-data"
if id "apache"   &>/dev/null; then WEB_USER="apache"; fi
if id "httpd"    &>/dev/null; then WEB_USER="httpd";  fi
if id "www-data" &>/dev/null; then WEB_USER="www-data"; fi

echo "Otorgando permisos totales de CD-ROM para el usuario: $WEB_USER"

# 1. Regla udev para persistencia
echo 'KERNEL=="sr*", GROUP="cdrom", MODE="0666"' > /etc/udev/rules.d/99-cdrom-robot.rules
echo 'KERNEL=="scd*", GROUP="cdrom", MODE="0666"' >> /etc/udev/rules.d/99-cdrom-robot.rules
udevadm control --reload-rules && udevadm trigger

# 2. Permisos inmediatos
chmod 666 /dev/sr* 2>/dev/null
chown root:cdrom /dev/sr* 2>/dev/null
usermod -aG cdrom,disk,optical "$WEB_USER"

# 3. Configuración sudoers (permitir todo lo relacionado a cdrom sin pass)
SUDOERS_FILE="/etc/sudoers.d/robot-medico-total"
cat > "$SUDOERS_FILE" << EOF
$WEB_USER ALL=(root) NOPASSWD: /usr/bin/eject *
$WEB_USER ALL=(root) NOPASSWD: /bin/eject *
$WEB_USER ALL=(root) NOPASSWD: $(pwd)/cdrom_helper.sh *
$WEB_USER ALL=(root) NOPASSWD: /bin/chmod 666 /dev/sr*
$WEB_USER ALL=(root) NOPASSWD: /usr/bin/chmod 666 /dev/sr*
EOF
chmod 440 "$SUDOERS_FILE"

echo "✅ Permisos aplicados. Por favor, reinicia el servicio del robot o el servidor web."
