#!/bin/bash
# Script para ejecutar el Robot de Grabación Médica en Linux

# Asegurar que estamos en el directorio correcto
cd "$(dirname "$0")"

echo "Iniciando Robot de Grabación Médica..."
echo "Asegúrese de tener instalado el paquete 'dvd+rw-tools' para soporte de grabación."

# Verificar si growisofs está instalado
if ! command -v growisofs &> /dev/null
then
    echo "ADVERTENCIA: 'growisofs' no se encuentra instalado. La grabación real no funcionará."
    echo "Instálelo con: sudo apt-get install dvd+rw-tools"
fi

# Ejecutar el script PHP
php robot.php
