-- Esquema de la base de datos para el Sistema de Robot de Grabación Médica

CREATE DATABASE IF NOT EXISTS robot_medico CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE robot_medico;

-- Tabla de estudios
CREATE TABLE IF NOT EXISTS estudios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    paciente VARCHAR(255) NOT NULL,
    fecha DATE NOT NULL,
    modalidad VARCHAR(50) NOT NULL,
    ruta_archivos VARCHAR(500) NOT NULL,
    tamaño BIGINT DEFAULT 0, -- en bytes
    estado ENUM('pendiente', 'preparando', 'esperando_disco', 'grabando', 'finalizado', 'error') DEFAULT 'pendiente',
    fecha_creacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    fecha_finalizacion TIMESTAMP NULL,
    comentarios TEXT
) ENGINE=InnoDB;

-- Tabla de logs
CREATE TABLE IF NOT EXISTS logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    estudio_id INT,
    evento VARCHAR(100) NOT NULL,
    mensaje TEXT NOT NULL,
    fecha TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (estudio_id) REFERENCES estudios(id) ON DELETE CASCADE
) ENGINE=InnoDB;

-- Tabla de configuración
CREATE TABLE IF NOT EXISTS configuracion (
    clave VARCHAR(50) PRIMARY KEY,
    valor VARCHAR(255) NOT NULL
) ENGINE=InnoDB;

-- Valores por defecto para la configuración
INSERT IGNORE INTO configuracion (clave, valor) VALUES 
('modo_automatico', '1'),
('velocidad_grabacion', '8x'),
('carpeta_monitoreo', 'c:/Users/Administrador/Downloads/SystemRobotWeb/estudios_pendientes'),
('unidad_optica', 'D:'),
('expulsar_al_terminar', '1');
