<?php
/**
 * Script de Probad de Hardware para el Robot Médico
 */
require_once 'config.php';

echo "====================================================\n";
echo "   PRUEBA DE DETECCIÓN DE HARDWARE (XAMPP + WIN)\n";
echo "====================================================\n\n";

$drive = UNIDAD_OPTICA;
echo "1. Verificando configuración: Unidad configurada en [$drive]\n";

// Prueba de comando WMIC
echo "2. Consultando Windows (WMIC)...\n";
$output = [];
exec("wmic cdrom get drive, medialoaded, status /format:list", $output);

$detectada = false;
$conMedia = false;

foreach ($output as $line) {
    if (empty(trim($line))) continue;
    echo "   > " . trim($line) . "\n";
    
    if (strpos($line, "Drive=$drive") !== false) {
        $detectada = true;
    }
    if (strpos($line, "MediaLoaded=TRUE") !== false && $detectada) {
        $conMedia = true;
    }
}

echo "\n----------------------------------------------------\n";
echo "RESULTADOS DE LA PRUEBA:\n";
echo "----------------------------------------------------\n";

if ($detectada) {
    echo "✅ UNIDAD DETECTADA: La unidad $drive existe en este sistema.\n";
    if ($conMedia) {
        echo "💿 DISCO DETECTADO: Hay un CD/DVD insertado y listo.\n";
    } else {
        echo "⚠️  DISCO NO DETECTADO: La bandeja está vacía o el disco es ilegible.\n";
    }
} else {
    echo "❌ UNIDAD NO ENCONTRADA: No se encontró la unidad $drive.\n";
    echo "   Por favor, verifica la letra de unidad en la pestaña 'Configuración' de la Web.\n";
}

echo "----------------------------------------------------\n";
echo "\n¿Deseas probar la expulsión física de la bandeja? (S/N): ";
