$ErrorActionPreference = "SilentlyContinue"
Write-Host "=== Test IMAPI2 / CD-ROM ==="
try {
    $m = New-Object -ComObject IMAPI2.MsftDiscMaster2
    $count = 0
    foreach ($id in $m) {
        $count++
        $r = New-Object -ComObject IMAPI2.MsftDiscRecorder2
        $r.InitializeDiscRecorder($id)
        Write-Host "Grabadora encontrada: $($r.DriveLetter): | ID=$id"
    }
    Write-Host "Total grabadoras IMAPI2: $count"
} catch {
    Write-Host "IMAPI2 no disponible o error: $_"
}

Write-Host ""
Write-Host "=== WMI CDROMDrive ==="
$drives = Get-WmiObject Win32_CDROMDrive -ErrorAction SilentlyContinue
if ($drives) {
    foreach ($d in $drives) {
        Write-Host "Drive: $($d.Id) | Name: $($d.Name) | MediaLoaded: $($d.MediaLoaded) | MediaType: $($d.MediaType)"
    }
} else {
    Write-Host "No se detectaron unidades CD-ROM via WMI"
}

Write-Host ""
Write-Host "=== WMI LogicalDisk Type=5 ==="
$ld = Get-WmiObject Win32_LogicalDisk -Filter "DriveType=5" -ErrorAction SilentlyContinue
if ($ld) {
    foreach ($d in $ld) {
        Write-Host "Unidad: $($d.DeviceID) | VolumeName: $($d.VolumeName) | FileSystem: $($d.FileSystem)"
    }
} else {
    Write-Host "No se encontraron discos opticos montados (DriveType=5)"
}
