# Estructura del Disco de Entrega - Sistema Robot Médico

Este documento describe la estructura de archivos y carpetas que el Robot de Grabación Médica genera automáticamente en cada CD/DVD para asegurar la correcta visualización de los estudios por parte del paciente o médico.

## 📂 Directorios en el Disco

| Carpeta | Descripción |
| :--- | :--- |
| `css/` | Contiene las hojas de estilo (CSS) para la interfaz visual del visor. |
| `js/` | Contiene el motor de renderizado DICOM (Cornerstone.js), el parseador y librerías de soporte. |
| `data/` | **Contenedor de Datos del Paciente.** Es el directorio donde se alojan las imágenes reales. |

## 📄 Archivos en el Directorio `data/`

*   **`paciente.json`**: Archivo fundamental generado dinámicamente. Contiene:
    *   Nombre del Paciente.
    *   Patient ID.
    *   Study Instance UID.
    *   Fecha y Modalidad.
    *   Lista de nombres de archivos de imagen para que el visor sepa qué cargar.
*   **Archivos `.dcm`**: Imágenes DICOM originales copiadas desde el sistema PACS/Detección.

## 📄 Lanzadores y Archivos de Control (Raíz del Disco)

| Archivo | Función |
| :--- | :--- |
| `index.html` | Archivo principal del visor. Ejecuta el visor médico en cualquier navegador moderno. |
| `autorun.inf` | Configura la reproducción automática en Windows (etiqueta del disco, icono y acción recomendada). |
| `VER_ESTUDIO.bat` | Lanzador directo para usuarios de Windows (doble clic para abrir). |
| `VER_ESTUDIO.sh` | Lanzador para usuarios de Linux (otorga compatibilidad multiplataforma). |

---

## ⚙️ Proceso de Generación Automatizada

1.  **Detección**: El Robot detecta un nuevo estudio en la carpeta de entrada.
2.  **Extracción**: Se leen los metadatos DICOM (UIDs, Paciente) de los archivos fuentes.
3.  **Clonación**: Se copia la estructura base del visor (`SystemRobotWeb/visor/`) al espacio temporal de grabación.
4.  **Inyección**: Se copian las imágenes DICOM a la carpeta `data/` del disco.
5.  **Indexación**: Se genera el `paciente.json` con los UIDs y la lista de archivos.
6.  **Grabado y Cierre**: Se quema el disco y se finaliza la sesión para asegurar compatibilidad en reproductores estándar.

---
*Sistema Robot de Grabación Médica V3.0*
