# 📖 Manual de Operación: Grabación Automática Inmediata

Este manual explica cómo configurar y operar el **Robot de Grabación Médica** para que detecte estudios y realice el quemado en CD/DVD de forma automática e inmediata.

---

## 🚀 1. Configuración Inicial del Robot

Para que el proceso sea automático, el "Robot" (el script de segundo plano) debe estar ejecutándose siempre.

### En Windows:
1. Abra una terminal (PowerShell o CMD).
2. Navegue a la carpeta del proyecto.
3. Ejecute el comando:
   ```powershell
   php backend/robot.php
   ```
   *Deje esta ventana abierta o minimizada.*

### En Linux (Servicio):
El sistema ya cuenta con un archivo de servicio. Una vez instalado, el robot corre solo:
```bash
sudo systemctl start robot-medico
```

---

## 🛠️ 2. Flujo de Trabajo para Grabación Inmediata

Siga estos pasos para una entrega rápida al paciente:

### Paso A: Recepción del Estudio
Coloque la carpeta del estudio médico en la carpeta compartida o local llamada `estudios_pendientes/`.
*   **Formato sugerido:** `NOMBRE_PACIENTE-MODALIDAD-FECHA`
*   **Ejemplo:** `PEDRO_Perez-RX-20260220`

### Paso B: Selección en el Dashboard
1. Desde cualquier equipo de la red, entre al panel: `http://[IP-DEL-SERVIDOR]/SystemRobotWeb/`
2. El nuevo estudio aparecerá en la lista de **"Gestión de Estudios"** con estado **PENDIENTE**.
3. Seleccione la **"Grabadora Activa"** (ej: D: o E:) donde pondrá el disco.
4. Haga clic en el botón azul **"Grabar"**. El estado cambiará a **ESPERANDO DISCO**.

### Paso C: Activación Automática (El momento clave)
**Simplemente inserte un CD o DVD blanco en la unidad seleccionada.**
1. El Robot detectará el disco en menos de 5 segundos.
2. La grabación iniciará **de inmediato** sin que usted tenga que presionar nada más.
3. Verá que el estado en la web cambia a **GRABANDO...**.

---

## 📀 3. Finalización y Entrega
*   Una vez que el progreso termine, el disco se **expulsará automáticamente**.
*   El estado cambiará a **FINALIZADO** (color verde).
*   El paciente ya puede llevarse su estudio. El disco incluye el **Visor DICOM Offline** que se abre solo al insertarlo en cualquier PC.

---

## 💡 Consejos para la Automatización Total

1.  **Mantenga discos blancos cerca:** Si deja un disco blanco puesto y luego presiona "Grabar" en la web, el proceso iniciará en ese mismo instante.
2.  **Múltiples grabadoras:** Si tiene mucha demanda, puede usar dos grabadoras (D: y E:). Puede asignar un paciente a la unidad D: y otro a la E: desde la web, y ambas grabarán al mismo tiempo.
3.  **Detección de errores:** Si el disco no es blanco o está dañado, el Dashboard mostrará un error y el log indicará "Medio no válido". Simplemente cambie el disco y el proceso reintentará.

---

## 📋 Requisitos para que funcione
*   **Carpeta Visor:** La carpeta `visor/` debe contener las librerías locales que descargamos.
*   **Permisos de PowerShell (Windows):** El sistema usa `burn_windows.ps1` para grabar sin programas externos.
*   **Permisos de CDROM (Linux):** El usuario debe pertenecer al grupo `cdrom`.
