import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'

// https://vite.dev/config/
export default defineConfig({
  plugins: [react()],
  base: './',

  build: {
    // ── Control de recursos para no congelar el equipo ──────────────────────
    // Limitar workers de Rollup a máximo 2 (por defecto usa todos los núcleos)
    rollupOptions: {
      maxParallelFileOps: 2,
      output: {
        // Separar vendors para build más rápido y caché más eficiente
        manualChunks(id) {
          if (id.includes('node_modules/react') || id.includes('node_modules/react-dom')) {
            return 'react-vendor';
          }
          if (id.includes('node_modules/')) {
            return 'vendor';
          }
        },
      },
    },
    // Umbral de chunks (reducir advertencias de tamaño)
    chunkSizeWarningLimit: 600,

    // Minificación: esbuild (mucho más rápido que terser y usa menos RAM)
    minify: 'esbuild',

    // Desactivar sourcemaps en producción para ahorrar RAM y tiempo
    sourcemap: false,

    // Desactivar inlining de assets pequeños para acelerar
    assetsInlineLimit: 0,

    // Limpiar directorio de salida antes de compilar
    emptyOutDir: true,

    // Directorio de salida
    outDir: 'dist',
  },

  // Optimización de dependencias pre-bundled en desarrollo
  optimizeDeps: {
    // Indicar qué dependencias pre-procesar en dev para evitar re-scaneos
    include: ['react', 'react-dom'],
    // Excluir dependencias no usadas realmente del análisis
    exclude: [],
  },

  // Limitar consumo de memoria del servidor de desarrollo
  server: {
    hmr: {
      overlay: true,
    },
  },
})
