<?php
/**
 * Script de Sincronización - Licencia y Frontend
 */

$root = 'c:/Users/Administrador/Downloads/SystemRobotWeb';
$xampp = 'c:/xampp/htdocs/SystemRobotWeb';

// 1. Sincronizar backend
if (file_exists("$root/backend/api.php")) copy("$root/backend/api.php", "$xampp/backend/api.php");
if (file_exists("$root/backend/config.php")) copy("$root/backend/config.php", "$xampp/backend/config.php");
if (file_exists("$root/backend/robot.php")) copy("$root/backend/robot.php", "$xampp/backend/robot.php");
if (file_exists("$root/backend/dicom_reader.php")) copy("$root/backend/dicom_reader.php", "$xampp/backend/dicom_reader.php");
if (file_exists("$root/backend/db.json")) copy("$root/backend/db.json", "$xampp/backend/db.json");

// 2. Sincronizar visor
if (is_dir("$root/visor")) {
    sync_dir("$root/visor", "$xampp/visor");
}

// 3. Sincronizar Frontend
function sync_dir($src, $dst) {
    if (!is_dir($dst)) @mkdir($dst, 0777, true);
    $dir = opendir($src);
    if (!$dir) return; // Protección si la carpeta no existe
    while(false !== ( $file = readdir($dir)) ) {
        if (( $file != '.' ) && ( $file != '..' )) {
            if ( is_dir($src . '/' . $file) ) {
                sync_dir($src . '/' . $file, $dst . '/' . $file);
            } else {
                copy($src . '/' . $file, $dst . '/' . $file);
            }
        }
    }
    closedir($dir);
}

if (is_dir("$root/frontend/dist")) {
    sync_dir("$root/frontend/dist", $xampp);
}

// 4. Sincronizar carpetas temporales (Necesario para el visor en XAMPP)
foreach (glob("$root/temp_disco_*", GLOB_ONLYDIR) as $temp_folder) {
    $folder_name = basename($temp_folder);
    sync_dir($temp_folder, "$xampp/$folder_name");
}

echo "Sincronización Total (Frontend, Backend, Visor y Carpetas Temporales) completada.";
