<?php
require_once 'backend/config.php';
require_once 'backend/dicom_reader.php';

$folder = RUTA_ESTUDIOS_PENDIENTES . '1.2.392.200036.9123.100.12.11.17750.202507025095228';
echo "Probando carpeta: $folder\n";

if (!is_dir($folder)) {
    die("Error: La carpeta no existe.\n");
}

$meta = DicomReader::getMetadataFromFolder($folder);

if ($meta) {
    echo "Metadatos encontrados:\n";
    print_r($meta);
} else {
    echo "No se encontraron metadatos DICOM.\n";
    
    echo "Listado de archivos sospechosos:\n";
    $it = new RecursiveDirectoryIterator($folder);
    foreach (new RecursiveIteratorIterator($it) as $file) {
        if ($file->isFile()) {
            $name = $file->getFilename();
            $ext = strtolower($file->getExtension());
            echo "- " . $file->getPathname() . " (Ext: '$ext', Name: '$name')\n";
        }
    }
}
